package raycast;

import java.awt.*;

/*******************************************************************************
* <p>Title: Project Raycast</p>
*
* @author Bernhard Schulz (www.bsyte.de)
* @version 1.0
*******************************************************************************/
public class Map3D
{
private int StartPlayerX   = 0;
private int StartPlayerY   = 0;
private int StartPlayerDir = 0;

private int TilesX   = 24;
private int TilesY   = 24;
private int TileSize = 64;
private int MapSizeX = TilesX * TileSize;
private int MapSizeY = TilesY * TileSize;

private static final byte O=0;  // Opening

byte[] map=
  {
   1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
   1, O, O, O, O, O, O, O, O, O, O, 1, O, O, O, O, O, O, O, O, O, O, O, 1,
   1, O, O, O, O, O, 1, 1, 1, 1, O, 1, O, O, O, O,38, O, O, O, O, O, O, 1,
   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, O, 1, 1, 1, 1, 1, 1, O, O, O, O, O, O, 1,
   1, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, 1, O, 1,
   1, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, 1, O, 1, 1, O, 1,
   1, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, 1, O, 1, O, O, 1,
   1, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, 1, O, 1, O, 1, 1,
   1, O, O, O, O, O,14,19,19,14, O, O, O, O, O, O, O, O, 1, O, 1, O, 1, 1,
   1, O, O, O, O, O,14, O, O,14, O, O, O, O, O, O, O, O, 1, O, 1, O, 1, 1,
   1, O, O, O, O, O,14, O, O,14, O, O, O, O, O, O, O, O, 1, O, 1, O, O, 1,
   1, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, 1, O, 1, 1, O, 1,
   1, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, 1, O, 1, 1, O, 1,
   1, 1, O, 1, 1, 1, 1, 1, 1, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, O, 1, 1, O, 1,
   1, 1, O, O, O, O, O, 1, 8, O, O, O, O, O, O, O, O, O, O, O, 5, O, O, 1,
   1, 8, 1, 1, 1, 1, O, 1, 8, O, O, O, O, O, O, O, O, O, 9, 1, 1, 1, 1, 1,
   8, O, 8, 8, 8, 8, 4, 8, 8, O, O, O, O, O, O, O, O, O, 8, 7, 7, 7, 7, 7,
   8, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, O, 8,
   8, O, 8,12,15,16,12,12,12,12,12,12, 8, 8, 8, 8, O,12,30,31,32,33, O, 8,
   8, O,11, O, O, O, O,10, O, O, O, O, O, O, O, 8, O,23, O, O, O, O,13, 8,
   8, O,11, O, O, O, O,10, O, O, O, O,37, O, O, 8, O,22, O, O, O, O, O,34,
   8, O,11, O, O, O, O,10, O, O, O, O,37, O, O, O, O,21, O, O, O, O, O,35,
   8, O, O, O, O, O, O,10, O, O, O, O,37, O, O, O, O,20, O, O, O, O, O,36,
   8,12,12,10,10,10,10,10,10,18,17,10,10,12,12,12,12,12,29,28,27,26,25,24
  };

private byte fMap[] = map;

private int[] WallTable=
      {
//    o r u l       // Oben Rechts Unten Links
      0,0,0,0,

      1,1,1,1,      // Wall #1 // Rot
      0,0,0,0,      // Wall #2 // Rot
      2,2,2,2,      // Wall #3 // Rot (Vodafone)
      3,0,4,0,      // Wall #4 // Rot (END)
      0,3,0,0,      // Wall #5 // Rot (END)
      0,0,4,0,      // Wall #6 // Oben rot unten blau
      5,5,4,5,      // Wall #7 // Gruen
      4,5,4,5,      // Wall #8 // Gruen
      0,0,5,5,      // Wall #9 // Gruen
      6,7,6,7,      // Wall #10 // Grau-HoF
      6,7,6,5,      // Wall #11 // Grau-HoF
      4,5,6,5,      // Wall #12 // Grau-HoF
      8,5,19,20,    // Wall #13 // END-HoF
      9,9,9,9,      // Wall #14 // Festung
      4,4,11,4,     // Wall #15 // Frank Text
      4,4,10,4,     // Wall #16 // Frank Bild
      13,4,13,4,    // Wall #17 // Erich Text
      12,4,12,4,    // Wall #18 // Erich Bild
      9,9,14,9,     // Wall #19 // Festung Innenseite
      15,15,15,5,   // Wall #20 // HAL 1
      16,16,16,5,   // Wall #21 // HAL 1
      17,17,17,5,   // Wall #22 // HAL 1
      18,18,18,5,   // Wall #23 // HAL 1
      20,20,20,20,  // Wall #24 // HAL 1
      21,21,21,21,  // Wall #25 // HAL 1
      22,22,22,22,  // Wall #26 // HAL 1
      23,23,23,23,  // Wall #27 // HAL 1
      24,24,24,24,  // Wall #28 // HAL 1
      25,25,25,25,  // Wall #29 // HAL 1
      4,1,26,26,    // Wall #30 // HAL 1
      4,1,27,27,    // Wall #31 // HAL 1
      4,1,28,28,    // Wall #32 // HAL 1
      4,1,29,29,    // Wall #33 // HAL 1
      30,30,30,30,  // Wall #34 // HAL 1
      31,31,31,31,  // Wall #35 // HAL 1
      32,32,32,32,  // Wall #36 // HAL 1
      4,5,6,7,      // Wall #37 // Grau-HoF
      0,0,0,33      // Wall #38 // Rot mit Teufel
      };

private TexturePool texPool = TexturePool.getInstance();

/*******************************************************************************
* Gibt die Texturenummer zurueck
* @param x Blockindex
* @param y Blockindex
* @param s Blockseite
* @return Index auf TextureTable !
*******************************************************************************/
public  int getTextureNr(int x, int y, int s)
  {
  int i = x + y * TilesY; // WallIndex
  int k = fMap[i];        // Wert der Wall aus der Map

  int index = (k*4) + s; //TileSide;
  int texIndex = WallTable[index];

  if (texIndex < texPool.countTextures())
    return (texIndex);
  else
    return (-1);
  }

/*******************************************************************************
* Gibt die Texturenummer zurueck
* @param x Blockindex
* @param y Blockindex
* @param s Blockseite
* @return Texturereferenz
*******************************************************************************/
public  Texture getTexture(int x, int y, int s)
  {
  int i =getTextureNr(x, y, s);
  return (texPool.get(i));
  }

/*******************************************************************************
* Konstruktor
*******************************************************************************/
public Map3D()
  {
  StartPlayerX   = 128;
  StartPlayerY   = 128;
  StartPlayerDir = 0;
  }

/*******************************************************************************
* Gibt den X-Wert der Player-Startkoordinate zurueck
* @return X-Koordiante
*******************************************************************************/
public int getStartPlayerX()
{
return (StartPlayerX);
}

/*******************************************************************************
* Gibt den Y-Wert der Player-Startkoordinate zurueck
* @return Y-Koordiante
*******************************************************************************/
public int getStartPlayerY()
{
return (StartPlayerY);
}

/*******************************************************************************
* Gibt den Blickwinkel des Player zurueck
* @return Winkel zwischen 0 und 360 Grad
*******************************************************************************/
public int getStartPlayerDir()
{
return (StartPlayerDir);
}

/*******************************************************************************
* Gibt die Anzahl der Tiles in X-Richtung zurueck
* @return Anzahl der X-Tiles
*******************************************************************************/
public int getTilesX()
{
return (TilesX);
}

/*******************************************************************************
* Gibt die Anzahl der Tiles in Y-Richtung zurueck
* @return Anzahl der Y-Tiles
*******************************************************************************/
public int getTilesY()
{
return (TilesY);
}

/*******************************************************************************
* Gibt die Ausdehnung einer Tile zurueck (ist immer Quadratisch, typ. 64)
* @return Groesse eines Tiles
*******************************************************************************/
public int getTileSize()
{
return (TileSize);
}

/*******************************************************************************
* Gibt die Ausdehnung der Map in X-Richtung zurueck
* @return Anzahl der Tiles
*******************************************************************************/
public int getMapSizeX()
{
return (MapSizeX);
}

/*******************************************************************************
* Gibt die Ausdehnung der Map in Y-Richtung zurueck
* @return Anzahl der Tiles
*******************************************************************************/
public int getMapSizeY()
{
return (MapSizeY);
}

/*******************************************************************************
* Testet, ob im Mapsegment x,y eine Wall oder freie Flaeche ist
* @param x Koordinate der Tile
* @param y Koordinate der Tile
* @return true->Mapsegment ist eine Wall, false->ist freie Flaeche
*******************************************************************************/
public boolean isWallTile(int x, int y)
{
if ((x < 0) || (y<0) || (x >= TilesX) || (y >= TilesY))
  return (true);

int i = x + y * TilesY;
if (fMap[i] == O)
   return (false);
return (true);
}

/*******************************************************************************
* Testet, ob im Mapsegment x,y eine Wall oder freie Flaeche ist
* @param x Koordinate der Tile
* @param y Koordinate der Tile
* @return true->Mapsegment ist eine Wall, false->ist freie Flaeche
*******************************************************************************/
public boolean isWallTile2(int x, int y)
{
if ((x < 0) || (y<0) || (x >= TilesX) || (y >= TilesY))
  return (true);

int i = x + y * TilesY;
if ((fMap[i] == O) || (fMap[i] == 13))
   return (false);
return (true);
}

/*******************************************************************************
* Testet, ob der Payer beim naechsten Schritt gegen eine Wall rennt
* @param xpos des Players
* @param ypos des Players
* @return true->Hoppla, da ist eine Wand false->Freie Flaeche
*******************************************************************************/
boolean tstCollision(int xpos, int ypos)
{
int x, y, x0, y0, x1, y1;
for (y=0; y < TilesY; y++)
   {
   for (x=0; x < TilesX; x++)
      {
      if (isWallTile2(x, y)== true)
        {
        x0 = x*TileSize;
        y0 = y*TileSize;
        x1 = x0 + TileSize;
        y1 = y0 + TileSize;
        if ((xpos >=x0) && (xpos <=x1) && (ypos >=y0) && (ypos <=y1))
          return (true);
        }
      }
   }
   return (false);
}

/*******************************************************************************
* Zeichnet die 2dimensionale Map
* @param g Graphikkontext
*******************************************************************************/
public void paint2D(Graphics g)
   {
   g.clearRect(0, 0, MapSizeX, MapSizeY);
   int x, y;
   for (y = 0; y < TilesY; y++)
      for (x = 0; x < TilesX; x++)
         if (isWallTile(x, y) == true)
            g.drawRect(x * TileSize, y * TileSize, TileSize, TileSize);
   }
}
