package raycast;

import java.awt.*;

/*******************************************************************************
* <p>Title: Project Raycast</p>
*
* @author Bernhard Schulz (www.bsyte.de)
* @version 1.0
*******************************************************************************/
public class Player
{
  private int PlayerPosX;
  private int PlayerAnimateDir = 0;

  private int PlayerPosY;
  private int PlayerPosZ = 0;
  private int PlayerDir;
  private int PlayerViewAngle;

  private int PlayerStep;
  private int PlayerTurn;

  private Arc   arc = Arc.getInstance();
  private Map3D map = null;
  
  public static final int STOP=0;
  public static final int STEP_FORWARD=1;
  public static final int STEP_BACKWARD=2;
  public static final int ROTATE_LEFT=3;
  public static final int ROTATE_RIGHT=4;

  private int m_moving   = STOP; // FORWARD, BACKWARD, STOP
  private int m_rotating = STOP; // LEFT, RIGHT, STOP
 

/*******************************************************************************
* Konstruktor
*******************************************************************************/
private void init() 
   {
   PlayerPosX = 1259;
   PlayerPosY = 1312;
   PlayerDir  = 1375; //arc.scale(0);
   PlayerViewAngle = arc.scale(60);

   PlayerStep = 2;            // Pixel nach vorn/hinten
   PlayerTurn = arc.scale(1); // Grad nach links/rechts
  }
  
/*******************************************************************************
* Konstruktor
*******************************************************************************/
  public Player()
  {
  init();
  }

/*******************************************************************************
* Konstruktor
*******************************************************************************/
  public Player(int x, int y)
  {
  init();
   PlayerPosX = x;
   PlayerPosY = y;
   }
 
  /******************************************************************************/
  /** \brief Wird in der Gameloop vor jedem Frame aufgerufen um die Kameraposition
             neu zu berechnen
  *******************************************************************************/
  void action()
  {
  if (m_moving == STEP_FORWARD)
     stepForward();
  else if (m_moving == STEP_BACKWARD)
     stepBackward();

  if (m_rotating == ROTATE_LEFT)
     stepTurnLeft();
  else if (m_rotating == ROTATE_RIGHT)
     stepTurnRight();
  }

  /******************************************************************************/
  /** \brief Setter fuer die auszufuehrende Vorwaerts-/Rueckwaertsbewegeung 
  *   \param STOP, STEP_FORWARD, STEP_BACKWARD 
  *******************************************************************************/
  void move(int step)
  {
  if ((step == STOP) || (step == STEP_FORWARD) || (step==STEP_BACKWARD))
    m_moving=step;
  }

  /******************************************************************************/
  /** \brief Getter fuer die auszufuehrende Vorwaerts-/Rueckwaertsbewegeung
  *   \return STOP, STEP_FORWARD, STEP_BACKWARD
  *******************************************************************************/
  int isMoving() {return (m_moving);}

  /******************************************************************************/
  /** \brief Setter fuer die auszufuehrende Drehbewegung 
  *   \param STOP, ROTATE_LEFT, ROTATE_RIGHT 
  *******************************************************************************/
  void rotate(int step)
  {
  if ((step == STOP) || (step == ROTATE_LEFT) || (step==ROTATE_RIGHT))
    m_rotating=step;
  }

  /******************************************************************************/
  /** \brief Getter fuer die auszufuehrende Drehbewegung
  *   \return STOP, ROTATE_LEFT, ROTATE_RIGHT
  *******************************************************************************/
  int isRotating() {return (m_rotating);}
  
/*******************************************************************************
* Registriert die Map
* @param m die Map
*******************************************************************************/
  public void setMap(Map3D m)
  {
  map = m;
  PlayerPosX = map.getStartPlayerX();
  PlayerPosY = map.getStartPlayerY();
  PlayerDir  = arc.scale(map.getStartPlayerDir());
  }

/*******************************************************************************
* Registriert die Map
* @param m die Map
*******************************************************************************/
  public void animate()
  {
  if (PlayerAnimateDir == 0)
     {
        PlayerPosZ += 5;
        if (PlayerPosZ >50)
           PlayerAnimateDir=1;
     }
   else
     {
        PlayerPosZ -= 5;
        if (PlayerPosZ < -50)
           PlayerAnimateDir=0;
     }
  }

/*******************************************************************************
* Gibt die aktuelle X-Position des Players zurueck
* @return X
*******************************************************************************/
public int getPosX()
{
return (PlayerPosX);
}

/*******************************************************************************
* Gibt die aktuelle Y-Position des Players zurueck
* @return Y
*******************************************************************************/
public int getPosY()
{
return (PlayerPosY);
}

/*******************************************************************************
* Gibt die aktuelle Blick, bzw. Gehrichtung Players zurueck
* @return direction
*******************************************************************************/
public int getDir()
{
return (PlayerDir);
}

/*******************************************************************************
* Gibt den max. Brennweite des Players zurueck
* @return Brennweite
*******************************************************************************/
public int getViewAngle()
{
return (PlayerViewAngle);
}

/*******************************************************************************
* Gehe einen Schritt Vorwaerts
*******************************************************************************/
  public void stepForward()
    {
    int x = PlayerPosX + (int)((double)PlayerStep * arc.cos(PlayerDir));
    int y = PlayerPosY + (int)((double)PlayerStep * arc.sin(PlayerDir));
    if (map.tstCollision(x, y) == false)
        {
        PlayerPosX = x;
        PlayerPosY = y;
        }
    }

/*******************************************************************************
* Gehe einen Schritt Rueckwaerts
*******************************************************************************/
  public void stepBackward()
    {
    int x = PlayerPosX - (int)((double)PlayerStep * arc.cos(PlayerDir));
    int y = PlayerPosY - (int)((double)PlayerStep * arc.sin(PlayerDir));
    if (map.tstCollision(x, y) == false)
        {
        PlayerPosX = x;
        PlayerPosY = y;
        }
    }

/*******************************************************************************
* Nach Rechts drehen
*******************************************************************************/
  public void stepTurnRight()
    {
    PlayerDir = arc.norm(PlayerDir + PlayerTurn);
    }

/*******************************************************************************
* Nach links drehen
*******************************************************************************/
  public void stepTurnLeft()
    {
    PlayerDir = arc.norm(PlayerDir - PlayerTurn);
    }

/*******************************************************************************
* Zeichnet den Player (in der 2D-Ansicht)
* @param g Graphikkontext
*******************************************************************************/
public void paint(Graphics g)
  {
  g.drawArc(PlayerPosX-5, PlayerPosY-5, 10, 10, 0, 360);

  double y = PlayerStep * 3 * arc.sin(PlayerDir);
  double x = PlayerStep * 3 * arc.cos(PlayerDir);
  g.drawLine(PlayerPosX, PlayerPosY, PlayerPosX + (int)x, PlayerPosY + (int)y);
  }

/*******************************************************************************
* Hilfsfunktion
*******************************************************************************/
public void dump()
  {
  System.out.println("paintPlayer x="   + PlayerPosX +
                                " y="   + PlayerPosY +
                                " dir=" + PlayerDir);
  }
}
