package raycast;

import java.awt.*;

/*******************************************************************************
* <p>Title: Project Raycast</p>
*
* @author Bernhard Schulz (www.bsyte.de)
* @version 1.0
*******************************************************************************/
public class Raycast
{
  private int PlayerPosX  = 0;
  private int PlayerPosY  = 0;
  private int PlayerDir   = 0;

  private int HorizontalX = 0;
  private int HorizontalY = 0;
  private int HitHorizontalTileX = 0;
  private int HitHorizontalTileY = 0;

  private int neu_HitWallSide = 0;

  private int VertikalX   = 0;
  private int VertikalY   = 0;
  private int HitVertikalTileX = 0;
  private int HitVertikalTileY = 0;

  private int TileOffset = 0;
  private boolean HorFlag = true;
  private int HitTileX = 0;
  private int HitTileY = 0;

  private double PlayerCastLen = 0;

  private Map3D  map = null;
  private Arc    arc = Arc.getInstance();

/*******************************************************************************
*
*******************************************************************************/
  public Raycast(Map3D  m)
  {
  map = m;
  }

/*******************************************************************************
*
*******************************************************************************/
public double calc(int x, int y, int w)
{
  PlayerPosX = x;
  PlayerPosY = y;
  PlayerDir  = w;

  calcCastHorizontal();
  calcCastVertical();
  calcCast();

  return(PlayerCastLen);
}

/*******************************************************************************
*
*******************************************************************************/
public int getTileOffset()
{
  return (TileOffset);
}

/*******************************************************************************
*
*******************************************************************************/
public boolean isHorizontal()
{
return (HorFlag);
}

/*******************************************************************************
*
*******************************************************************************/
public int getHitTileX()
{
return (HitTileX);
}

/*******************************************************************************
*
*******************************************************************************/
public int getHitTileY()
{
return (HitTileY);
}

/*******************************************************************************
*
*******************************************************************************/
public int getHitTileSide()
{
return (neu_HitWallSide);
}

/*******************************************************************************
*
*******************************************************************************/
private void calcCast()
{
double len1 = Math.sqrt(HorizontalX*HorizontalX +  HorizontalY*HorizontalY);
double len2 = Math.sqrt(VertikalX*VertikalX +  VertikalY*VertikalY);
if(len1 < len2)
   {
   neu_HitWallSide = 0;
   if (HorizontalY < 0)
     neu_HitWallSide = 2;

   HorFlag = true;
   PlayerCastLen = len1;
   HitTileX = HitHorizontalTileX;
   HitTileY = HitHorizontalTileY;
   TileOffset = (HorizontalX + PlayerPosX) % map.getTileSize();
   }
else
   {
   neu_HitWallSide = 3;
   if (VertikalX < 0)
     neu_HitWallSide = 1;

   HorFlag = false;
   PlayerCastLen = len2;
   HitTileX = HitVertikalTileX;
   HitTileY = HitVertikalTileY;
   TileOffset = (VertikalY + PlayerPosY) % map.getTileSize();
   }
}

/*******************************************************************************
*
*******************************************************************************/
private void calcCastHorizontal()
{
int TileSize   = map.getTileSize();
int MapSizeX   = map.getMapSizeX();
int MapSizeY   = map.getMapSizeY();

int tileX = PlayerPosX / TileSize;
int tileY = PlayerPosY / TileSize;
int x0    = PlayerPosX % TileSize;
int y0    = PlayerPosY % TileSize;
int tx=0, ty=0;
double dx=0, dy=0, dxTile=0;

if ((arc.getARC0() <= PlayerDir) && (PlayerDir < arc.getARC180()))
   { // Winkel von 0 bis 179 Grad Blickrichtung nach UNTEN
   dy = TileSize - y0;
   if (PlayerDir == 0)
     {
     dx = MapSizeX-PlayerPosX;
     }
   else if (PlayerDir == arc.getARC270())
     {
     dx = 0;
     dxTile = 0;
     }
   else if (PlayerDir == arc.getARC180())
     {
     dx = -PlayerPosX;
     }
   else
     {
     dx = dy / arc.tan(PlayerDir);
     dxTile = (double)(TileSize) / arc.tan(PlayerDir);
     }

   ty = tileY+1;
   tx = (PlayerPosX + (int)dx ) / TileSize;

   while(map.isWallTile(tx, ty)==false)
      {
      dx += dxTile;
      dy += TileSize;

      ty = ty+1;
      tx = (PlayerPosX + (int)dx ) / TileSize;
      }
   }
else // Winkel von 180 bis 360 Grad --> Blickrichtung nach OBEN !!
   {
   dy = -y0;
   dy--; 
   if (PlayerDir == 0)
     {
     dx = MapSizeX-PlayerPosX;
     }
   else if (PlayerDir == arc.getARC270())
     {
     dx = 0;
     dxTile = 0;
     }
   else if (PlayerDir == arc.getARC180())
     {
     dx = -PlayerPosX;
     }
   else
     {
     dx = dy / arc.tan(PlayerDir);
     dxTile = -(double)(TileSize) / arc.tan(PlayerDir);
     }

   ty = tileY-1;
   tx = (PlayerPosX + (int)dx) / TileSize;

   while(map.isWallTile(tx, ty)==false)
      {
      dx += dxTile;
      dy -= TileSize;
      ty = ty-1;
      tx = (PlayerPosX + (int)dx) / TileSize;
      }
   }

HitHorizontalTileX = tx;
HitHorizontalTileY = ty;

HorizontalX= (int)dx;
HorizontalY= (int)dy;
}

/*******************************************************************************
* Konstruktor
*******************************************************************************/
private void calcCastVertical()
{
int TileSize   = map.getTileSize();
int MapSizeX   = map.getMapSizeX();
int MapSizeY   = map.getMapSizeY();

int tileX = PlayerPosX / TileSize;
int tileY = PlayerPosY / TileSize;
int x0    = PlayerPosX % TileSize;
int y0    = PlayerPosY % TileSize;
int tx=0, ty=0;
double dx=0, dy=0, dyTile=0;

if ((PlayerDir >= arc.getARC90()) && (PlayerDir <= arc.getARC270()))
   { // Blickrichtung nach LINKS
   dx = -x0;
   dx--;
   if (PlayerDir == arc.getARC270())
     {
     dy = PlayerPosY;
     }
   else if (PlayerDir == arc.getARC90())
     {
     dy = MapSizeY-PlayerPosY;
     }
   else
     {
     dy = dx * arc.tan(PlayerDir);
     dyTile = -(double)(TileSize) * arc.tan(PlayerDir);
     }
   tx = tileX-1;
   ty = (PlayerPosY + (int)dy) / TileSize;

   while(map.isWallTile(tx, ty)==false)
      {
      dy += dyTile;
      dx -= TileSize;

      tx = tx-1;
      ty = (PlayerPosY + (int)dy) / TileSize;
      }
   }
else
   { // nach RECHTS schauen
   dx = TileSize - x0;
   if (PlayerDir == arc.getARC270())
     {
     dy = PlayerPosY;
     }
   else if (PlayerDir == arc.getARC90())
     {
     dy = MapSizeY-PlayerPosY;
     }
   else
     {
     dy = dx * arc.tan(PlayerDir);
     dyTile = (double)(TileSize) * arc.tan(PlayerDir);
     }

   tx = tileX+1;
   ty = (PlayerPosY + (int)dy) / TileSize;

   while(map.isWallTile(tx, ty)==false)
      {
      dy += dyTile;
      dx += TileSize;

      tx = tx+1;
      ty = (PlayerPosY + (int)dy) / TileSize;
      }
   }

HitVertikalTileX = tx;
HitVertikalTileY = ty;

VertikalX= (int)dx;
VertikalY= (int)dy;
}

/*******************************************************************************
*
*******************************************************************************/
public void paint(Graphics g)
  {
  double dx = PlayerCastLen * arc.cos(PlayerDir);
  double dy = PlayerCastLen * arc.sin(PlayerDir);
  g.drawLine(PlayerPosX, PlayerPosY, PlayerPosX + (int)dx, PlayerPosY + (int)dy);
  }

/*******************************************************************************
*
*******************************************************************************/
public void dump()
  {
  System.out.println("Raycast raylen=" + (int)PlayerCastLen +
                     " Tile[" + HitTileX + "," + HitTileY+ "] horizontal=" + HorFlag +
                     " TileSide=" + neu_HitWallSide);
  }
}
