
package raycast;

import javax.swing.*;
import java.awt.*;
import java.awt.event.KeyEvent;
import java.awt.image.*;

/*******************************************************************************
* <p>Title: Project Raycast</p>
*
* @author Bernhard Schulz (www.bsyte.de)
* @version 1.0
*******************************************************************************/
public class RaycastPanel extends JPanel implements Runnable
  {
  private  Image  imgDefault = null;
  private boolean start  = false;
  private Map3D   map    = null;
  private Player  player = null;
  private Raycast ray    = null;
  private View2D  view2d = null;
  private View3D  view3d = null;

/*******************************************************************************
* Konstruktor
* @param texturePath Pfad zu den Texturen, Images
*******************************************************************************/
  public RaycastPanel(String texturePath)
  {
  super();

  Arc.initInstance(5);    
  map = new Map3D();      
  player = new Player();   
  player.setMap(map);      
  ray = new Raycast(map); 
  view2d = new View2D(map, player); 
  view3d = new View3D(map, player); 

  imgDefault = getToolkit().getImage(texturePath + "startlogo.gif");

  TexturePool tp = TexturePool.getInstance();
  tp.build(texturePath, texturePath + "texturen.dat");
  tp.load (texturePath + "texturen.dat");

  Image img = this.getToolkit().getImage(texturePath + "ceiling2.gif");

//view3d.setCeiling(img);                    
  view3d.setCeiling( toBufferedImage(img));  

  img = this.getToolkit().getImage(texturePath + "floor.gif");
  view3d.setFloor(img);
  }

  /*******************************************************************************
  * run
  *******************************************************************************/
 public void start()
     {
     Thread th = new Thread(this);
     th.start();
     }
 
/*******************************************************************************
* run
*******************************************************************************/
 public void run()
   {
   while (true)
      {
	  player.action();
	  repaint();
	  try
	     {
		 Thread.sleep(10);	  
	     }
	  catch (InterruptedException ex)
	     {}
      }
   }
 
 /*******************************************************************************
 * Vorwaerts
 *******************************************************************************/
   public void action()
     {
     player.action();
     }

/*******************************************************************************
* Input
*******************************************************************************/
public void keyInput(boolean pressed, int key)
    {
	// Move forward and backward:
	if ((key == KeyEvent.VK_UP) && (pressed==true) && (player.isMoving() == Player.STOP))
		player.move(Player.STEP_FORWARD);
	else if ((key == KeyEvent.VK_DOWN) && (pressed==true) && (player.isMoving()==Player.STOP))
	   player.move(Player.STEP_BACKWARD);   

	if ((key==KeyEvent.VK_UP) && (pressed==false) && (player.isMoving()==Player.STEP_FORWARD))
	   player.move(Player.STOP);
	else if ((key==KeyEvent.VK_DOWN) && (pressed==false) && (player.isMoving()==Player.STEP_BACKWARD))
		player.move(Player.STOP);
	  
		
    // Rotate left, Rotate right
	if ((key == KeyEvent.VK_LEFT) && (pressed==true) && (player.isRotating()==Player.STOP))
	   player.rotate(Player.ROTATE_LEFT);
	else if ((key == KeyEvent.VK_RIGHT) && (pressed==true) && (player.isRotating()==Player.STOP))
	   player.rotate(Player.ROTATE_RIGHT);   
	
	if ((key==KeyEvent.VK_LEFT) && (pressed==false) && (player.isRotating()==Player.ROTATE_LEFT))
	   player.rotate(Player.STOP);
	else if ((key==KeyEvent.VK_RIGHT) && (pressed==false) && (player.isRotating()==Player.ROTATE_RIGHT))
		player.rotate(Player.STOP);

	// Sonstige Tasten...
	if (pressed == true)
	    {
	    if (key == KeyEvent.VK_SPACE) this.keyStart(true);
	    if (key == KeyEvent.VK_F2)    this.keySpecial();
	    }
	}

/*******************************************************************************
* Taste fuer 'Start' wurde betaetigt. Damit wird die Map ein- oder ausgeblendet
* @param flag true->Map einblenden, false->Map ausblenden
*******************************************************************************/
  public void keyStart(boolean flag)
    {
	start();  
    start = flag;
    }

/*******************************************************************************
* Taste fuer 'Start' wurde betaetigt. Gibt die Playerposition nach stdout aus
*******************************************************************************/
  public void keySpecial()
    {
    player.dump();
    long fr = view3d.getFramerate();
    System.out.println("Framerate=" + fr);
    }

/*******************************************************************************
*
*******************************************************************************/
  private void scrollWall()
    {
    int xTileNr  = 5;
	int yTileNr  = 18;
	int WallSide = 2;
	Texture myTexture = map.getTexture(xTileNr, yTileNr, WallSide);
    myTexture.scroll(Texture.SCROLL_LEFT);
    
    xTileNr  = 9;
	yTileNr  = 23;
	WallSide = 0;
	myTexture = map.getTexture(xTileNr, yTileNr, WallSide);
    myTexture.scroll(Texture.SCROLL_LEFT);
    }

/*******************************************************************************
* Zeichenet in Abhaengigkeit vom start-flag das Intro-Image oder die Map
* @param g Graphikkontext
*******************************************************************************/
  public void paint(Graphics g)
    {
    if (start == false)
      {
      if (imgDefault != null)
         g.drawImage(imgDefault, 0, 0, this);
      }
    else
      {
      scrollWall();
    	
      //map.paint2D(g);
      //player.paint(g);
      //ray.paint(g);
      //view2d.paint(g);

      view3d.paint(g);
      }
    }

/*******************************************************************************
*
*******************************************************************************/
private static BufferedImage toBufferedImage(Image image)
  {
  image = new ImageIcon(image).getImage();
  BufferedImage bimage = null;
  GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
  try
    {
    int transparency = Transparency.BITMASK;
    GraphicsDevice gs = ge.getDefaultScreenDevice();
    GraphicsConfiguration gc = gs.getDefaultConfiguration();
    bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
    }
  catch (Exception e)
    {
	System.out.println("RaycastPanel.toBufferedImage Exception:" +  e.getMessage());
    }

  if (bimage == null)
    {
    int type = BufferedImage.TYPE_INT_ARGB;
    bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
    }

  Graphics g = bimage.createGraphics();
  g.drawImage(image, 0, 0, null);
  g.dispose();

  return bimage;
  }
}
