package raycast;

import java.io.*;
import java.awt.image.*;

/*******************************************************************************
* <p>Title: Project Raycast</p>
*
* @author Bernhard Schulz (www.bsyte.de)
* @version 1.0
*******************************************************************************/
public class Texture
 {
 public static int SCROLL_LEFT  = 1;
 public static int SCROLL_RIGHT = 2; 
 public static int SCROLL_TOP   = 3;
 public static int SCROLL_DOWN  = 4;
 
 private int height = 0;
 private int width  = 0;
 public  int alpha  = 0; // 0-->ohne Alpha, 1-->mit Alpha

 public byte[][][] PixArray = null;

/*******************************************************************************
*
*******************************************************************************/
public boolean isAlpha()
{
if (alpha == 0)
   return (false);
return(true);
}

/*******************************************************************************
*
*******************************************************************************/
public int scanLine(int x0, int y0, int w)
{
int i=0, n=0, x=0, y=0;
double m=0;

int maxlen = (int)Math.sqrt((width*width)+(height*height)) + 1;
int pixLine[][] = null;
pixLine = new int[maxlen][3];

if (w == 0)
   {
   for (x=x0, y=y0, i=0; x < this.width; x++, i++)
      {
      pixLine[i][0] = PixArray[x][y][0];
      pixLine[i][1] = PixArray[x][y][1];
      pixLine[i][2] = PixArray[x][y][2];
      }
   }
else if (w < 90)
   {
   m = Math.tan((Math.PI * w) / 180.0);
   for (i=0; ;i++)
      {
      x = x0 + i;
      y = (int)((double)i*m);
      if ((x >= this.width) || (y >= this.height))
         break;
      pixLine[i][0] = PixArray[x][y][0];
      pixLine[i][1] = PixArray[x][y][1];
      pixLine[i][2] = PixArray[x][y][2];
      }
   }
else if (w == 90)
  {
   for (x=x0, y=y0, i=0; y < this.height; y++, i++)
      {
      pixLine[i][0] = PixArray[x][y][0];
      pixLine[i][1] = PixArray[x][y][1];
      pixLine[i][2] = PixArray[x][y][2];
      }
  }
else if (w < 180)
  {
  }
else if (w == 180)
  {
   for (x=x0, y=y0, i=0; x >= 0; x--, i++)
      {
      pixLine[i][0] = PixArray[x][y][0];
      pixLine[i][1] = PixArray[x][y][1];
      pixLine[i][2] = PixArray[x][y][2];
      }
  }
else if (w < 270)
  {
  }
else if (w == 270)
  {
   for (x=x0, y=y0, i=0; y >= 0; y--, i++)
      {
      pixLine[i][0] = PixArray[x][y][0];
      pixLine[i][1] = PixArray[x][y][1];
      pixLine[i][2] = PixArray[x][y][2];
      }
  }
else // w < 320 !!
  {
  }

for (n=0; n < i; n++)
     {
     if (pixLine[n][0] == 0)
        System.out.print("-");
     else
        System.out.print("+");
     }

return (i);
}

/*******************************************************************************
* Bresenham-Algorithmus
*******************************************************************************/
public int scanLine(int x0, int y0, int x1, int y1)
{
int maxlen = (int)Math.sqrt((width*width)+(height*height)) + 1;
int pixLine[][] = null;
pixLine = new int[maxlen][3];

int dx=0, dy= 0, i=0, x=0, y=0, xstep=0, ystep=0, abweichung=0;

x = x0; y = y0; dy = Math.abs(y1-y0);
dx = Math.abs(x1-x0); abweichung = dx - dy;

pixLine[i][0] = PixArray[x][y][0];
pixLine[i][1] = PixArray[x][y][1];
pixLine[i][2] = PixArray[x][y][2];
i++;

if (x1 > x0) xstep=1; else xstep = -1;
if (y1 > y0) ystep=1; else ystep = -1;

while ((x != x1) || (y != y1))
      {
      if (abweichung >= 0 )
         {
         x = x +xstep; abweichung = abweichung - dy;
         }
      if (abweichung < 0)
         {
         y = y + ystep; abweichung = abweichung + dx;
         }

      pixLine[i][0] = PixArray[x][y][0];
      pixLine[i][1] = PixArray[x][y][1];
      pixLine[i][2] = PixArray[x][y][2];
      i++;
      }

return (i);
}
/*******************************************************************************
*
*******************************************************************************/
 public boolean compare(Texture t)
 {
 int x,y,v;

 if ((this.width != t.width) || (this.height != t.height))
   {
   System.out.println("compare Error width="  + width  + "/" + t.width +
                                   " height=" + height + "/" + t.height);
   return (false);
   }

 for (x=0; x<width; x++)
  for (y=0; y<height; y++)
   for (v=0; v<3; v++)
     if (PixArray[x][y][v] != t.PixArray[x][y][v])
      {
      System.out.println("compare Error at x=" + x+ " y=" + y + " v=" + v);
      return (false);
      }

 return(true);
 }

/*******************************************************************************
*
*******************************************************************************/
  public Texture()
  {
  }

/*******************************************************************************
*
*******************************************************************************/
  public Texture(int h, int w)
  {
  height = h;
  width  = w;

  PixArray = new byte[width][height][3];

  int x,y;
  for (x=0; x<width; x++)
     for (y=0; y<height; y++)
        {
        PixArray[x][y][0] = (byte)0;
        PixArray[x][y][1] = (byte)0;
        PixArray[x][y][2] = (byte)0;
//      PixArray[x][y][3] = (byte)0;
        }
  }

  /*******************************************************************************
  * 
  *******************************************************************************/
    public void scroll(int dir)
    {
    int x,y;	
    byte[] val = new byte[3];
    
    if (dir == Texture.SCROLL_LEFT)  
       {
       for (y=0; y<height; y++)
          {
    	  val[0] = PixArray[0][y][0]; 
    	  val[1] = PixArray[0][y][1];
    	  val[2] = PixArray[0][y][2];
          for (x=0; x<(width-1); x++)
             {
        	  PixArray[x][y][0] = PixArray[x+1][y][0]; 
        	  PixArray[x][y][1] = PixArray[x+1][y][1];
        	  PixArray[x][y][2] = PixArray[x+1][y][2];
             }
    	  PixArray[width-1][y][0] = val[0]; 
    	  PixArray[width-1][y][1] = val[1];
    	  PixArray[width-1][y][2] = val[2];
          }
       }
    // TODO: die restlichen Scrollrichtungen implementieren
    }

  
/*******************************************************************************
*
*******************************************************************************/
  public Texture(Raster r)
  {
  int cval[] = new int[4];

  height = r.getHeight();
  width  = r.getWidth();

  PixArray = new byte[width][height][3];

  System.out.println("height=" + height + " width=" + width);

  int x,y;
  for (x=0; x<width; x++)
     for (y=0; y<height; y++)
        {
        r.getPixel(x, y, cval);
        PixArray[x][y][0] = (byte)cval[0];
        PixArray[x][y][1] = (byte)cval[1];
        PixArray[x][y][2] = (byte)cval[2];
//        PixArray[x][y][3] = (byte)cval[3];
        }
  }

/*******************************************************************************
*
*******************************************************************************/
  public Texture(Raster r, boolean alpha)
  {
  int x=0,y=0;
  int cval[] = new int[4];

  height = r.getHeight();
  width  = r.getWidth();

  System.out.println("height=" + height + " width=" + width);

  if (alpha == true)
     {
     PixArray = new byte[width][height][4];
     for (x = 0; x < width; x++)
        for (y = 0; y < height; y++)
        {
           r.getPixel(x, y, cval);
           PixArray[x][y][0] = (byte)cval[0];
           PixArray[x][y][1] = (byte)cval[1];
           PixArray[x][y][2] = (byte)cval[2];
           PixArray[x][y][3] = (byte)cval[3];
//           System.out.println("trans=" + cval[3] + " PixArray[x][y][3]=" + PixArray[x][y][3]);
        }
     }
  else
     {
     PixArray = new byte[width][height][3];
     for (x = 0; x < width; x++)
        for (y = 0; y < height; y++)
        {
           r.getPixel(x, y, cval);
           PixArray[x][y][0] = (byte)cval[0];
           PixArray[x][y][1] = (byte)cval[1];
           PixArray[x][y][2] = (byte)cval[2];
        }
     }
  }

/*******************************************************************************
*
*******************************************************************************/
public void load(DataInputStream dataIn) throws IOException
{
   int i,x,y,v;
   byte[] buf = null;
   try
      {
      width =  dataIn.readInt();
      height = dataIn.readInt();
      buf = new byte[width*height*3];
      PixArray = new byte[width][height][3];
      dataIn.read(buf, 0, width*height*3);

      for (x=0, i=0; x<width; x++)
         for (y=0; y<height; y++)
            for (v=0; v<3; v++)
               PixArray[x][y][v] = buf[i++];
      }
   catch (EOFException eof)
      {
      System.out.println( "EOF" );
      }
}

/*******************************************************************************
*
*******************************************************************************/
public void save(DataOutputStream dataOut) throws IOException
{
int i,x,y,v;
byte[] buf = new byte[width*height*3];

dataOut.writeInt(width);
dataOut.writeInt(height);

for (x=0, i=0; x<width; x++)
    for (y=0; y<height; y++)
       for (v=0; v<3; v++)
         buf[i++] = PixArray[x][y][v];

dataOut.write(buf, 0, width*height*3);
}

}
