package raycast;

import java.io.*;
import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import java.util.*;

/*******************************************************************************
* <p>Title: Project Raycast</p>
*
* @author Bernhard Schulz (www.bsyte.de)
* @version 1.0
*******************************************************************************/
public class TexturePool extends JPanel
{
private static TexturePool _instance = null;
private java.util.List<Texture> texList  = new LinkedList<Texture>();

private Texture texDummy = new Texture(64, 64);

/*******************************************************************************
*
*******************************************************************************/
  private TexturePool()
  {
  }

/*******************************************************************************
*
*******************************************************************************/
public static TexturePool getInstance()
  {
  if (_instance == null)
    _instance = new TexturePool();
  return (_instance);
  }

/*******************************************************************************
* Voodoo !
*******************************************************************************/
public void build(String texturePath, String datfile)
{
  int i;
  boolean status = true;
  Image img = null;

  String[] giffiles = {
  "wall64-red01.gif",
  "wall64-red02.gif",
  "wall64-vodafone.gif",
  "wall64-red03.gif",
  "wall64-g1.gif",
  "wall64-g2.gif",
  "wall64-01.gif",
  "wall64-02.gif",
  "wall64-end2.gif",
  "wall64-10.gif",
  "wall64-f0.gif",
  "wall64-f1.gif",
  "wall64-e0.gif",
  "wall64-e1.gif",
  "wall64-11.gif",
  "wall64-hal01.gif",
  "wall64-hal02.gif",
  "wall64-hal03.gif",
  "wall64-hal04.gif",
  "wall64-hal05.gif",
  "wall64-hal06.gif",
  "wall64-hal07.gif",
  "wall64-hal08.gif",
  "wall64-hal09.gif",
  "wall64-hal10.gif",
  "wall64-hal11.gif",
  "wall64-hal13.gif",
  "wall64-hal14.gif",
  "wall64-hal15.gif",
  "wall64-hal16.gif",
  "wall64-hal17.gif",
  "wall64-hal18.gif",
  "wall64-hal19.gif",
  "wall64-red04.gif",
  "floor64.gif",
  "cross.gif"
  };

  for (i=0; i < 36; i++)
    {
    System.out.println("loadGIF "+ i + " |" + texturePath + giffiles[i] + "|");
    File file = new File(texturePath + giffiles[i]);
    if (file.exists() == true)
      {
      img = this.getToolkit().getImage(texturePath + giffiles[i]);
      this.loadGIF(img);
      }
    else
      {
      System.out.println("TexturePool.build File not found:" + texturePath + giffiles[i]);
      status = false;
      }
    }

  if (status == true)
    {
    save(datfile);
    verify(datfile);
    System.out.println("Texturen gelesen!");
    }
  else
    {
    System.out.println("Error creating texturefile!");
    }
}

/*******************************************************************************
*
*******************************************************************************/
public int countTextures()
{
  return(texList.size());
}

/*******************************************************************************
*
*******************************************************************************/
public Texture get(int index)
{
  if ((index >= 0) && (index < texList.size()))
     {
     return ((Texture)texList.get(index));
     }
  else
     {
     return (texDummy);
     }
}

/*******************************************************************************
*
*******************************************************************************/
public void save(String fname)
{
  int i;
  Texture t = null;
  int size = texList.size();

  File file = new File(fname);
  try
    {
    FileOutputStream fileOutput = new FileOutputStream(file);
    DataOutputStream dataOut    = new DataOutputStream(fileOutput);

    dataOut.writeInt(size);    // Anzahl Texturen schreiben
    for (i=0; i < size; i++)
       {
       t = (Texture)texList.get(i);
       t.save(dataOut);
       }
    dataOut.close();
    }
  catch (IOException e)
    {
    }
}

/*******************************************************************************
*
*******************************************************************************/
public void load(String fname)
{
  File file = new File(fname);
  int i, size=0;

  texList.clear();
  try
    {
    FileInputStream fileInput = new FileInputStream(file);
    DataInputStream dataIn =    new DataInputStream( fileInput );

    size = dataIn.readInt(); // Anzahl Texturen
    for (i=0; i < size; i++)
      {
      Texture  t = new  Texture();
      t.load(dataIn);
      texList.add(t);
      }
    }
  catch (EOFException eof)
    {
    System.out.println( "EOF" );
    }
  catch (IOException e)
    {
    System.out.println( "TexturePool.load: Fehler beim laden der Texturen aus " + fname );
    }

//  Texture myT = this.get(34);
//  myT.scanLine(2,0,9,4);
}

/*******************************************************************************
*
*******************************************************************************/
public void verify(String fname)
{
  java.util.List<Texture> texList2 = new LinkedList<Texture>();
  File file = new File(fname);
  int i, size=0;

  texList2.clear();
  try
    {
    FileInputStream fileInput = new FileInputStream(file);
    DataInputStream dataIn =    new DataInputStream( fileInput );

    size = dataIn.readInt(); // Anzahl Texturen
    for (i=0; i < size; i++)
      {
      Texture  t = new  Texture();
      t.load(dataIn);
      texList2.add(t);
      }
    }
  catch (EOFException eof)
    {
    System.out.println( "EOF" );
    }
  catch (IOException e)
    {
    System.out.println( "TexturePool.verify: Fehler beim laden der Texturen aus " + fname );
    }

  for (i=0; i < size; i++)
    {
    Texture t1 = (Texture)texList.get(i);
    Texture t2 = (Texture)texList2.get(i);
    if (t1.compare(t2) == false)
      System.out.println( "Fehler beim vergleichen " + i);
    }
}

/*******************************************************************************
*
*******************************************************************************/
private boolean loadGIF(Image img)
{
BufferedImage WallImage = toBufferedImage(img);
Texture t = new Texture(WallImage.getRaster());
texList.add(t);
return (true);
}

/*******************************************************************************
*
*******************************************************************************/
private static BufferedImage toBufferedImage(Image image)
  {
  image = new ImageIcon(image).getImage();
  BufferedImage bimage = null;
  GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
  try
    {
    int transparency = Transparency.BITMASK;
    GraphicsDevice gs = ge.getDefaultScreenDevice();
    GraphicsConfiguration gc = gs.getDefaultConfiguration();
    bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
    }
  catch (Exception e)
    {
    }

  if (bimage == null)
    {
    int type = BufferedImage.TYPE_INT_ARGB;
    bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
    }

  Graphics g = bimage.createGraphics();
  g.drawImage(image, 0, 0, null);
  g.dispose();

  return bimage;
  }
}
