package raycast;

import java.awt.*;

/*******************************************************************************
* <p>Title: Project Raycast</p>
*
* @author Bernhard Schulz (www.bsyte.de)
* @version 1.0
*******************************************************************************/
public class View2D
{
private int xOffset = 400;
private int yOffset = 0;

private int width  = 320;
private int height = 200;

private Arc arc = Arc.getInstance();

private Map3D map     = null;
private Player player = null;
private Raycast ray   = null;

/*******************************************************************************
*
*******************************************************************************/
  public View2D(Map3D m, Player p)
  {
  map    = m;
  player = p;
  ray = new Raycast(map);
  }

/*******************************************************************************
*
*******************************************************************************/
public void paint(Graphics g)
  {
//  g.clearRect(xOffset,yOffset,width, height);
//  g.drawRect(xOffset,yOffset,width, height);

  int i, w;
  double len;
  w = arc.norm(player.getDir() - arc.scale(30));
  for (i=0; i<arc.scale(60); i++)
    {
    len = ray.calc(player.getPosX(), player.getPosY(), w);
    ray.paint(g);
    w = arc.norm(w+1);
    }
  }
}
