package raycast;

import java.awt.*;
import java.awt.image.*;

/*******************************************************************************
* <p>Title: Project Raycast</p>
*
* @author Bernhard Schulz (www.bsyte.de)
* @version 1.0
*******************************************************************************/
public class View3D
{
private long RenderTimeMS = 0;

//private Image ceiling;       
private BufferedImage ceiling; 

private Image floor;

private int PlaneOffsetX = 0;
private int PlaneOffsetY = 0;

private int PlaneSizeX    = 320;
private int PlaneSizeY    = 200;
private int PlaneDistance = 0;
private double SliceArc   = 0;
private int[] SliceArray = new int[1024];

private Arc arc = Arc.getInstance();
private double[] fishTable = new double[1000];

private Map3D map     = null;
private Player player = null;
private Raycast ray   = null;

private BufferedImage  PlaneImage  = null;
private WritableRaster PlaneRaster = null;
private int[]          PlanePixels = null;

/*******************************************************************************
* Konstruktor fuer die 3D-View
* @param m die Map
* @param p der Player
*******************************************************************************/
  public View3D(Map3D m, Player p)
  {
  int i;
  map    = m;
  player = p;
  ray = new Raycast(map);

  PlaneDistance = (int) (((double)PlaneSizeX / 2.0) * arc.tan(player.getViewAngle()));
  SliceArc = (double)player.getViewAngle() / (double)PlaneSizeX;

  for (i=0; i<=PlaneSizeX; i++)
    SliceArray[i] = (int)(i * SliceArc);

  PlaneImage = new BufferedImage(320, 200, BufferedImage.TYPE_4BYTE_ABGR);
  PlaneRaster = PlaneImage.getRaster();
  PlanePixels = new int[4*320*200];

  clearPlane();

  PlaneRaster.setPixels(0, 0, 320, 200, PlanePixels);
  PlaneImage.setData(PlaneRaster);

  for (i=0; i <= arc.scale(60); i++)
     fishTable[i] = arc.cos(arc.norm(i-arc.scale(30)));
  }

/*******************************************************************************
* Registriert das Image fuer den Himmel (oder die Hoelle, je nachdem :-))
* @param img Image
*******************************************************************************/
//  public void setCeiling(Image img)       
  public void setCeiling(BufferedImage img) 
  {
  ceiling = img;
  }

/*******************************************************************************
* Registriert das Image fuer den Boden
* @param img Image
*******************************************************************************/
  public void setFloor(Image img)
  {
  floor = img;
  }

/*******************************************************************************
* Gibt die Framerate zurueck
* @return Framerate
*******************************************************************************/
 public long getFramerate()
 {
 if (RenderTimeMS == 0)
    return (-1);
 return (1000 / RenderTimeMS);
 }

/*******************************************************************************
* Zeichnet die 3D-Sicht
* @param g Graphikkontext
*******************************************************************************/
public void paint(Graphics g)
  {
  Texture myTexture = null;

  TexturePool tp = TexturePool.getInstance();
  Texture floorTexture = tp.get(34); // FloorTexture

  g.clearRect(PlaneOffsetX, PlaneOffsetY, PlaneSizeX, PlaneSizeY);
  g.drawRect (PlaneOffsetX, PlaneOffsetY, PlaneSizeX, PlaneSizeY);
  paintFloor(g);
  paintCeiling(g);

  double raylen = 0, sliceheight=0;
  int debugCount=0;
  int tileOffset=0;
  int i, k, w, y=0, yy;
  int wPrev = -1;
  int a=0;
  int WallSide = 0;
  int xTileNr=0, yTileNr=0;
  int cval[] = new int[10];

  int wStart = arc.norm(player.getDir() - arc.scale(30));
  int PlaneSize = 4*320*200;
  double intensity = 0;

  long t1 = System.currentTimeMillis();
  clearPlane();

  for (i=0; i <=PlaneSizeX; i++)
    {
    w = arc.norm(SliceArray[i] + wStart);
    if (wPrev != w)
      {
      wPrev       = w;
      raylen      = ray.calc(player.getPosX(), player.getPosY(), w) * fishTable[a++];

      intensity   = (1-(0.000488 * raylen));
      tileOffset  = ray.getTileOffset();
      sliceheight = (map.getTileSize() / raylen) * PlaneDistance;

      xTileNr   = ray.getHitTileX();
      yTileNr   = ray.getHitTileY();
      WallSide  = ray.getHitTileSide();
      myTexture = map.getTexture(xTileNr, yTileNr, WallSide);
      
      y = (int)(((double)PlaneSizeY - sliceheight) / 2.0);
      }

   // -----------------------------------------------------------------------
   // FloorPainting START
   // -----------------------------------------------------------------------
   int yyy = (int)((200 - sliceheight) / 2.0);
   double ph = (double) PlaneSizeY/2; // 200 / 2 = 100
   int xp = 90; // 90 Voodoo !!!
   double floorIntensity = (1-(0.000488 * raylen));

   if (w == 0)
     {
//     System.out.println("raylen=" + raylen + " sliceheigh=" + sliceheight + " yyy=" + yyy);
     }

   if (yyy > 0)
      {
      double ssin = arc.sin(w);
      double ccos = arc.cos(w);

      for (int yi=yyy; yi >=0; yi--)
         {
         double ll = (ph*xp)/(ph-yi) / fishTable[a-1];

         floorIntensity = (1-(0.000488 * ll));
         int _y_ = (int)(ll * ssin ) + player.getPosY();
         int _x_ = (int)(ll * ccos ) + player.getPosX();

         _x_ = _x_ % 64;
         _y_ = _y_ % 64;
         cval[0] = (int)floorTexture.PixArray[_x_][_y_][0] & 0xff;
         cval[1] = (int)floorTexture.PixArray[_x_][_y_][1] & 0xff;
         cval[2] = (int)floorTexture.PixArray[_x_][_y_][2] & 0xff;
         cval[3] = (int)0;

         int kkk = ((200 - yi)*320 +  i) * 4;

         if (kkk >= PlaneSize)
            continue;

         PlanePixels[kkk]     = (int) ((double)cval[0] * floorIntensity); // R
         PlanePixels[kkk + 1] = (int) ((double)cval[1] * floorIntensity); // G
         PlanePixels[kkk + 2] = (int) ((double)cval[2] * floorIntensity); // B
         PlanePixels[kkk + 3] = 255; // Alpha
         }
      }
   // -----------------------------------------------------------------------
   // FloorPainting END
   // -----------------------------------------------------------------------

    double d = (double)map.getTileSize() / sliceheight;

    for (yy=0; yy < sliceheight; yy++)
      {
      if ((y+yy) < 0)
        continue;

      k=((y+yy)*320+i) * 4;
      if (k >= PlaneSize)
        continue;

      cval[0] = (int)myTexture.PixArray[tileOffset][(int)((double)yy*d)][0] & 0xff;
      cval[1] = (int)myTexture.PixArray[tileOffset][(int)((double)yy*d)][1] & 0xff;
      cval[2] = (int)myTexture.PixArray[tileOffset][(int)((double)yy*d)][2] & 0xff;
      cval[3] = (int)0;

     PlanePixels[k] =   (int) ((double)cval[0] * intensity); // R
     PlanePixels[k+1] = (int) ((double)cval[1] * intensity); // G
     PlanePixels[k+2] = (int) ((double)cval[2] * intensity); // B
     PlanePixels[k+3] = 255;                                 // Alpha
    }
  }

  PlaneRaster.setPixels(0, 0, 320, 200, PlanePixels);
  PlaneImage.setData(PlaneRaster);
  g.drawImage(PlaneImage, PlaneOffsetX, PlaneOffsetY, null);

  long t2 = System.currentTimeMillis();
  RenderTimeMS = t2 - t1;
  }

/*******************************************************************************
* Zeichnet den Boden
* @param g Graphikkontext
*******************************************************************************/
private void paintFloor(Graphics g)
{
  if (floor != null)
      g.drawImage(floor, PlaneOffsetX, PlaneOffsetY + 100, null);
}

/*******************************************************************************
* Zeichnet den Himmel TRITON
* @param g Graphikkontext
*******************************************************************************/
private void paintCeiling(Graphics g)
{
  int width, x, xs, xe, xlen = ceiling.getWidth();
  int dir;
  if (ceiling != null)
      {
      dir = player.getDir() / 5;
      x = (int)((320.0/60.0) * dir);
      xs = x % xlen;
      xe = xs + 320;

      if ((xs >= 0) && (xe <= xlen))
         {
         width = 320;
         BufferedImage subImage = ceiling.getSubimage(xs, 0, width, 100);
         g.drawImage(subImage, PlaneOffsetX, PlaneOffsetY, null);
         }
     else if ((xs >= 0) && (xe > xlen))
         {
         width = xlen - xs;
         BufferedImage subImageL = ceiling.getSubimage(xs,0, width, 100);
         g.drawImage(subImageL, PlaneOffsetX, PlaneOffsetY, null);

         BufferedImage subImageR = ceiling.getSubimage(0,0, 320 - width, 100);
         g.drawImage(subImageR, PlaneOffsetX+width, PlaneOffsetY, null);
         }
      }
}

/*******************************************************************************
*
*******************************************************************************/
private void clearPlane()
{
  for (int i=0; i < (200*320*4); i++)
    PlanePixels[i]   = 0;
}

}
